@echo off
:: ============================================================
::  הגדרת קיוסק - סקריפט אוטומטי
::  מזהה את המשתמש הנוכחי ומגדיר הכל אוטומטית
::  הרץ בתור Administrator!
:: ============================================================

:: בדוק הרשאות Administrator
net session >nul 2>&1
if %errorLevel% neq 0 (
    echo.
    echo שגיאה: יש להריץ סקריפט זה בתור Administrator!
    echo לחץ ימני על הקובץ ובחר "הפעל כמנהל"
    echo.
    pause
    exit /b 1
)

:: קבל שם משתמש נוכחי
set CURRENT_USER=%USERNAME%
echo.
echo ========================================
echo   הגדרת קיוסק עבור משתמש: %CURRENT_USER%
echo ========================================
echo.

:: מצא את נתיב ה-EXE של הקיוסק (באותה תיקייה כמו הסקריפט)
set SCRIPT_DIR=%~dp0
set KIOSK_EXE=%SCRIPT_DIR%KioskApp.exe

if not exist "%KIOSK_EXE%" (
    echo שגיאה: לא נמצא KioskApp.exe בתיקייה זו!
    echo ודא שהסקריפט נמצא באותה תיקייה כמו KioskApp.exe
    echo.
    pause
    exit /b 1
)

echo [1/5] מגדיר הפעלה אוטומטית בעת כניסה למשתמש (Run)...
reg add "HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\Run" ^
    /v "KioskApp" ^
    /t REG_SZ ^
    /d "\"%KIOSK_EXE%\"" ^
    /f >nul
echo      [OK]

echo [2/5] מגדיר Task Scheduler להפעלה מהירה בהתחברות...
:: מחיקת משימה ישנה אם קיימת
schtasks /delete /tn "KioskAutoStart" /f >nul 2>&1
:: יצירת משימה שמפעילה את הקיוסק עם עיכוב של 10 שניות לאחר כניסת משתמש
schtasks /create /tn "KioskAutoStart" ^
    /tr "\"%KIOSK_EXE%\"" ^
    /sc onlogon ^
    /ru "%CURRENT_USER%" ^
    /delay 0000:10 ^
    /rl highest ^
    /f >nul
echo      [OK] - הקיוסק יעלה 10 שניות לאחר כניסה

echo [3/5] מגדיר מדיניות מסך נעילה (Ctrl+Alt+Del)...

:: חסום Task Manager
reg add "HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\Policies\System" ^
    /v "DisableTaskMgr" /t REG_DWORD /d 1 /f >nul

:: חסום Lock Computer במסך Ctrl+Alt+Del
reg add "HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\Policies\System" ^
    /v "DisableLockWorkstation" /t REG_DWORD /d 1 /f >nul

:: חסום Change Password במסך Ctrl+Alt+Del
reg add "HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\Policies\System" ^
    /v "DisableChangePassword" /t REG_DWORD /d 1 /f >nul

:: חסום Sign Out במסך Ctrl+Alt+Del
reg add "HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\Policies\Explorer" ^
    /v "NoLogoff" /t REG_DWORD /d 1 /f >nul

:: חסום Shut Down במסך Ctrl+Alt+Del
reg add "HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\Policies\Explorer" ^
    /v "NoClose" /t REG_DWORD /d 1 /f >nul

:: *** תיקון: חסום Switch User / החלף משתמש ***
reg add "HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\Policies\System" ^
    /v "HideFastUserSwitching" /t REG_DWORD /d 1 /f >nul

echo      [OK]

echo [4/5] חוסם גישה ל-Task Manager...
:: חסום Task Manager גם ברמת HKLM (לכל המשתמשים)
reg add "HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Policies\System" ^
    /v "DisableTaskMgr" /t REG_DWORD /d 1 /f >nul
echo      [OK]

echo [5/5] מגדיר כניסה אוטומטית למשתמש...
reg add "HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Winlogon" ^
    /v "AutoAdminLogon" /t REG_SZ /d "1" /f >nul
reg add "HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Winlogon" ^
    /v "DefaultUserName" /t REG_SZ /d "%CURRENT_USER%" /f >nul
reg add "HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Winlogon" ^
    /v "DefaultDomainName" /t REG_SZ /d "." /f >nul
echo      [OK] - הכנס סיסמת Windows בשלב הבא

echo.
echo ========================================
echo   שלב אחרון - הכנסת סיסמת Windows
echo   (נדרש לכניסה אוטומטית)
echo   אם אין סיסמה - השאר ריק ולחץ Enter
echo ========================================
set /p WIN_PASSWORD=הכנס סיסמת Windows של המשתמש "%CURRENT_USER%": 

reg add "HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Winlogon" ^
    /v "DefaultPassword" /t REG_SZ /d "%WIN_PASSWORD%" /f >nul

echo.
echo ========================================
echo   ההגדרה הושלמה בהצלחה!
echo.
echo   מה הוגדר:
echo   [v] קיוסק יעלה אוטומטית בכניסה למשתמש
echo   [v] כניסה אוטומטית בהפעלת המחשב
echo   [v] Ctrl+Alt+Del - כיבוי/יציאה/נעילה חסומים
echo   [v] החלף משתמש (Switch User) חסום
echo   [v] Task Manager חסום
echo   [v] Task Scheduler - הקיוסק עולה 10 שניות אחרי כניסה
echo.
echo   להסרת ההגדרות - הרץ Uninstall_Kiosk.bat
echo ========================================
echo.
pause
